{********************************************
; File: Lists.p
;
;
; Copyright Apple Computer, Inc. 1986-90
; All Rights Reserved
;
********************************************}

UNIT LISTS;
INTERFACE
USES TYPES,QUICKDRAW,EVENTS,CONTROLS;
CONST

{ ListType Masks }
cString = $0001;  { null terminated string type }
LIST_STRG = $0001;  { null terminated string type }
selectOnlyOne = $0002;  { only one selection allowed }
LIST_SELECT = $0002;  { single selection only }

{ memFlag Codes }
memDisabled = $40;  { Sets member flag to disabled }
memSelected = $80;  { Sets member flag to selected }
TYPE
LColorTableHndl = ^LColorTablePtr;
LColorTablePtr = ^LColorTable;
LColorTable = RECORD
    listFrameClr : Integer; { Frame color }
    listNorTextClr : Integer; { Unhighlighted text color }
    listSelTextClr : Integer; { Highlighted text color }
    listNorBackClr : Integer; { Unhighlighted background color }
    listSelBackClr : Integer; { Highlighted backgraound color }
END;
MemRecHndl = ^MemRecPtr;
MemRecPtr = ^MemRec;
MemRec = PACKED RECORD
    memPtr : Ptr; { Pointer to string, or custom }
    memFlag : Byte; { Bit Flag }
END;

{ The MemRec is followed by n bytes determined by value of listMemSize field }
ListCtlRecHndl = ^ListCtlRecPtr;
ListCtlRecPtr = ^ListCtlRec;
ListCtlRec = PACKED RECORD
    ctlNext : CtlRecHndl; { Handle of Next Control }
    ctlOwner : WindowPtr; { Window owner }
    ctlRect : Rect; { Enclosing Rect }
    ctlFlag : Byte; { Bit 7 visible; Bit 0 string type; Bit 1 multiple }
    ctlHilite : Byte; { (not used) }
    ctlValue : Integer; { First member in display }
    ctlProc : LongProcPtr; { Address of list definition procedure }
    ctlAction : LongProcPtr; { Address of list action procedure }
    ctlData : Longint; { Low = view size; High = total members }
    ctlRefCon : Longint; { Not used }
    ctlColor : Ptr; { Null for default colors }
    ctlMemDraw : VoidProcPtr; { Address of routine to draw members }
    ctlMemHeight : Integer; { Member's Height in Pixels }
    ctlMemSize : Integer; { Bytes in member record }
    ctlList : MemRecPtr; { Adress of first member record in array }
    ctlListBar : CtlRecHndl; { Handle of list contrlo's scroll bar control }
END;
ListRecHndl = ^ListRecPtr;
ListRecPtr = ^ListRec;
ListRec = RECORD
    listRect : Rect; { Enclosing Rectangle }
    listSize : Integer; { Number of List Members }
    listView : Integer; { Max Viewable members }
    listType : Integer; { Bit Flag }
    listStart : Integer; { First member in view }
    listCtl : CtlRecHndl; { List control's handle }
    listDraw : VoidProcPtr; { Address of Custom drawing routine }
    listMemHeight : Integer; { Height of list members }
    listMemSize : Integer; { Size of Member Records }
    listPointer : MemRecPtr; { Pointer to first element in MemRec array }
    listRefCon : Longint; { becomes Control's refCon }
    listScrollClr : BarColorsPtr; { Color table for list's scroll bar }
END;
FUNCTION CreateList ( theWindowPtr:WindowPtr; newListRecPtr:ListRec) : ListCtlRecHndl ;
PROCEDURE DrawMember ( memberPtr:MemRecPtr; aListRecPtr:ListRec)  ;
PROCEDURE DrawMember2 ( itemNumber:Integer; ctlHandle:CtlRecHndl)  ;
FUNCTION GetListDefProc  : LongProcPtr ;
PROCEDURE ListBootInit   ;
PROCEDURE ListReset   ;
PROCEDURE ListShutDown   ;
PROCEDURE ListStartup   ;
FUNCTION ListStatus  : Boolean ;
FUNCTION ListVersion  : Integer ;
PROCEDURE NewList ( memberPtr:MemRecPtr; newListRecPtr:ListRec)  ;
PROCEDURE NewList2 ( drawProcPtr:ProcPtr; listStart:Integer; listRef:Ref; listRefDesc:RefDescriptor; listSize:Integer; ctlHandle:CtlRecHndl)  ;
FUNCTION  NextMember ( memberPtr:MemRecPtr; aListRecPtr:ListRec) : MemRecPtr ;
FUNCTION NextMember2 ( itemNumber:Integer; ctlHandle:CtlRecHndl) : Integer ;
FUNCTION ResetMember ( aListRecPtr:ListRec) : MemRecPtr ;
FUNCTION ResetMember2 ( ctlHandle:CtlRecHndl) : Integer ;
PROCEDURE SelectMember ( memberPtr:MemRecPtr; aListRecPtr:ListRec)  ;
PROCEDURE SelectMember2 ( itemNumber:Integer; ctlHandle:CtlRecHndl)  ;
PROCEDURE SortList ( comparePtr:VoidProcPtr; aListRecPtr:ListRec)  ;
PROCEDURE SortList2 ( comparePtr:ProcPtr; ctlHandle:CtlRecHndl)  ;
IMPLEMENTATION
END.
